C SAMPLE PROGRAM FOR DFZERO
C
      DOUBLE PRECISION     B, C, AE, RE, F
      EXTERNAL F
C
      B   = 2.0D0
      C   = 3.0D0
      AE  = 1.0D-06
      RE  = 1.0D-06
      WRITE (*,*) ' INITIAL INTERVAL: '
      WRITE (*,'(8X,2D18.10)') B, C
      WRITE (*,*) ' TOLERANCES:       '
      WRITE (*,'(8X,2D18.10)') AE, RE
C
      CALL DFZERO (F, B, C, C, RE, AE, IFLAG)
C
      WRITE (*,*)
      WRITE (*,*) 'DFZERO RESULTS'
      IF (IFLAG .NE. 1) WRITE (*,*) ' ERROR CODE =', IFLAG
      WRITE (*,'(A19,2X,D18.10)') ' ESTIMATE OF ZERO =', B
      WRITE (*,'(A19,2X,D18.10)') ' FUNCTION VALUE =', F(B)
C
      WRITE (*,*)
      WRITE (*,*) 'REFERENCE RESULTS FROM IBM PC/AT'
      WRITE (*,*) ' ESTIMATE OF ZERO =   0.2094551435E+01'    
      WRITE (*,*) '   FUNCTION VALUE =  -0.5157851953E-06'
C
      STOP
      END
C
C
      DOUBLE PRECISION FUNCTION F(X)
      DOUBLE PRECISION X
C
      F = X * (X*X-2.0D0) - 5.0D0
C
      RETURN
      END

